//------------------------------------------------------------
uniform sampler2D mmv_frametexture;

uniform int mmv_width;
uniform int mmv_height;
uniform int mmv_frametexture_width;
uniform int mmv_frametexture_height;


// ------------------------------------------------------------
void main( void )
{
	float mmv_tex_x		= float( mmv_frametexture_width );
	float mmv_tex_y		= float( mmv_frametexture_height );
	float mmv_disp_x	= float( mmv_width );
	float mmv_disp_y	= float( mmv_height );

	vec2	div;
	div.x	= mmv_disp_x / mmv_tex_x;
	div.y	= mmv_disp_y / mmv_tex_y;
	vec2	uv	= gl_TexCoord[ 0 ].st * div;
	
	vec2	offset;
	offset.x	= div.x / mmv_disp_x;
	offset.y	= div.y / mmv_disp_y;

	uv	= uv + ( offset / 2.0 );

	offset	= offset * ( mmv_disp_y / 256.0 );
	
	vec4	tex;
	tex	= vec4( 0.0, 0.0, 0.0, 0.0 );

	vec4	orig_tex	= texture2D( mmv_frametexture, uv );
	vec4	t;
	float	v;
	
	int	div_ct	= 5;
	int	i	= 0;	int j	= 0;
	for( i = 0 ; i < div_ct ; i++ ){
		for( j = 0 ; j < div_ct ; j++ ){
			t	= texture2D( mmv_frametexture, clamp( uv + vec2( offset.x * float( i - div_ct / 2 ), offset.y * float( j - div_ct / 2 ) ), vec2( 0.0 ), div ) );
//			v	= t.r;	v	= max( v, t.g );	v	= max( v, t.b );
//			v	= ( t.r + t.g + t.b ) / 3.0;
//			tex	= tex + vec4( pow( t.rgb * max( v - 240.0 / 256.0, 0.0 ) * ( 256.0 / 16.0 ), vec3( 1.0 ) ), tex.a );
			tex	= tex + vec4( max( t.rgb - 240.0 / 256.0, vec3( 0.0 ) ) * ( 256.0 / 16.0 ), tex.a );
		}
	}

//	float	ov	= orig_tex.r;	ov	= max( ov, orig_tex.g );	ov	= max( ov, orig_tex.b );
//	float	ov	= ( orig_tex.r + orig_tex.g + orig_tex.b ) / 3.0;
	gl_FragColor	= vec4( tex.rgb / float( div_ct * div_ct ) * ( vec3( 1.0 ) - orig_tex.rgb ), 1.0 );	//o
}
