//------------------------------------------------------------
// cel_paint

//------------------------------------------------------------
uniform sampler2D mmv_tex0; // eNX`
uniform sampler2D mmv_tex2; // EXeNX`1
//uniform sampler2D mmv_tex3; // EXeNX`2
uniform sampler2DShadow	mmv_shadowbuffer;

//------------------------------------------------------------
varying vec3 VERTEX_NORMAL;	// @xNg
varying vec3 VERTEX_LIGHT;	// CgxNg
varying vec3 VERTEX_LIGHT2;	// CgxNg
varying vec3 VERTEX_EYE;	// xNg

// ------------------------------------------------------------
// tOgVF[_vO
// ------------------------------------------------------------
void main( void )
{
	vec3	N	= normalize(VERTEX_NORMAL);	// @xNg
	vec3	L	= normalize(VERTEX_LIGHT);	// CgxNg
	vec3	L2	= normalize(VERTEX_LIGHT2);	// CgxNg
	vec3	E	= normalize(VERTEX_EYE);	// xNg
	vec3	R	= reflect( L, N );			// ˃xNg
	vec3	R2	= reflect( L2, N );			// ˃xNg
	
	//F
	vec4	tex		= texture2D( mmv_tex0, gl_TexCoord[ 0 ].st );
	vec3	color	= tex.rgb;
	float	a		= tex.a;
//	vec3	color	= gl_FrontMaterial.diffuse.rgb;	//}eAF
//	float	a		= gl_FrontMaterial.diffuse.a;	//sx

	//
//	float	lumi	= texture2D( mmv_tex3, gl_TexCoord[ 0 ].st ).r;

	//
	float	offset	= 1.5 / 2048.0;
	float	ret		= 0.0;

	vec4	coord	=	gl_TexCoord[ 1 ];
	coord.z	= coord.z - 0.005;
	
	ret	= ret + shadow2DProj( mmv_shadowbuffer, coord + vec4( 0.0, 0.0, 0.0, 0.0 ) ).r;
	ret	= ret + shadow2DProj( mmv_shadowbuffer, coord + vec4( offset, offset, 0.0, 0.0 ) ).r;
	ret	= ret + shadow2DProj( mmv_shadowbuffer, coord + vec4( -offset, offset, 0.0, 0.0 ) ).r;
	ret	= ret + shadow2DProj( mmv_shadowbuffer, coord + vec4( offset, -offset, 0.0, 0.0 ) ).r;
	ret	= ret + shadow2DProj( mmv_shadowbuffer, coord + vec4( -offset, -offset, 0.0, 0.0 ) ).r;
	ret	= ret / 5.0;

	float	amb;
	amb	= pow( 1.0 - dot( N, -E ), 3.0 );
	
	//
	float	dif		= max( dot( N, L ), 0.0 ) * 0.65;	//gUxi̋j
	float	dif2	= max( dot( N, L2 ), 0.0 ) * 0.25;	//gUxi̋j
	dif	= min( ( dif + dif2 ) * ret + amb, 1.0 );
	
	dif	= dif * ( 254.0 / 256.0 ) + ( 1.0 / 256.0 );	//ItZbg
	
	vec4	cel_tex	= texture2D( mmv_tex2, vec2( dif, 0.5 ) );
	vec3	cel1	= vec3( cel_tex.a );
	vec3	cel2	= cel_tex.rgb;
	

	//XyL
	float	powr	= gl_FrontMaterial.shininess;	//˂̋
	float	s_dif	= gl_FrontMaterial.specular.r;	//ˌ(rgb)
	
	float	spec	= pow( max( dot( R, E ), 0.0 ), powr ) * s_dif;
	spec	= spec + pow( max( dot( R2, E ), 0.0 ), powr ) * s_dif;
	
	
	if( dot( E, N ) > -0.1 )	gl_FragColor	= vec4( 0, 0, 0, 1.0 );
	else						gl_FragColor	= vec4( color * cel1 + cel2 + vec3( spec ), a );	//o
}
